/* 
 * riminfo.S: RIM information
 *
 * Copyright (C) Panasonic  Co., Ltd.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#include <asm/asm-offsets.h>

#ifdef CONFIG_RT3_TRACE
#include <asm/rt3.h>
#endif /* CONFIG_RT3_TRACE */


.macro RIMINFO symbol, value
.global \symbol
.equiv  \symbol, \value
.endm

	.text

#ifdef CONFIG_SMP
	RIMINFO RIM_KERNEL_LINUX_SMP,		1
#else /* CONFIG_SMP */
	RIMINFO RIM_KERNEL_LINUX_SMP,		0
#endif /* CONFIG_SMP */

#ifdef CONFIG_RT3_TRACE
	RIMINFO RIM_VAL_TRACE_FREQ,		__RT3_TSCCLK >> RT3_TRACE_TIMESTAMP_SHIFT
#endif /* CONFIG_RT3_TRACE */

	RIMINFO RIM_OFFSET_TASK_STATE,		TASK_STATE
	RIMINFO RIM_OFFSET_TASK_THREADINFO,	TASK_THREADINFO
	RIMINFO RIM_OFFSET_TASK_RT,		TASK_RT
	RIMINFO RIM_OFFSET_TASK_TASKS,		TASK_TASKS
	RIMINFO RIM_OFFSET_TASK_MM,		TASK_MM
	RIMINFO RIM_OFFSET_TASK_PID,		TASK_PID
	RIMINFO RIM_OFFSET_TASK_COMM,		TASK_COMM
	RIMINFO RIM_OFFSET_TASK_THREAD,		TASK_THREAD
	RIMINFO RIM_OFFSET_TASK_THREAD_GROUP	TASK_THREAD_GROUP
	RIMINFO RIM_OFFSET_RTENTITY_RUNLIST,	RTENTITY_RUNLIST

	RIMINFO RIM_OFFSET_THREAD_SP,		THREAD_SP
	RIMINFO RIM_OFFSET_MM_PGD,		MM_PGD

#ifdef CONFIG_SMP
	RIMINFO RIM_WIDTH_PER_CPU_OFFSET,	0x04	/* */
#endif /* CONFIG_SMP */

	RIMINFO RIM_OFFSET_KNLSTK_PC,		0x04	/* */
	RIMINFO RIM_OFFSET_KNLSTK_USP,		0x30	/* */

	RIMINFO RIM_SIZE_IRQDESC,		SIZE_IRQDESC
	RIMINFO RIM_OFFSET_IRQDESC_ACTION,	IRQDESC_ACTION
	RIMINFO RIM_WIDTH_ACTION,		0x04	/* */
	RIMINFO RIM_OFFSET_IRQACTION_NAME,	IRQACTION_NAME
	RIMINFO RIM_WIDTH_IRQACTION_NAME,	0x04	/* */
	RIMINFO RIM_OFFSET_IRQACTION_NEXT,	IRQACTION_NEXT
	RIMINFO RIM_WIDTH_IRQACTION_NEXT,	0x04	/* */

	RIMINFO RIM_LINUX_SOFTIRQ_PID,		RT3_TRACE_SOFTIRQ_PID
